﻿/*
================================================================================
	Name		:	Com_Kanasansoft_LinkForPage
	In			:	[none]		
	Out			:	[none]		
	Note		:	Kanasansoft Blog Editor用テンプレート
--------------------------------------------------------------------------------
	Version		:	Ver1.0.0	|	2006/12/02	|	新規作成
				:	Ver1.1.0	|	2006/12/12	|	getIdの追加
				:	Ver1.2.0	|	2006/12/13	|	項目[Target]の追加
				:	Ver1.2.1	|	2006/12/13	|	スキーマ[http]を必須から任意へ変更
--------------------------------------------------------------------------------
	License		:	New BSD license
	URL			:	www.kanasansoft.com
================================================================================
*/

/*--------------------------------------------------------------------------------
	コンストラクタ
--------------------------------------------------------------------------------*/
function Com_Kanasansoft_LinkForPage(){
	this._Text					=	"";
	this._Url					=	"http://";
	this._Target				=	"";
}

/*--------------------------------------------------------------------------------
	データ取得
--------------------------------------------------------------------------------*/
Com_Kanasansoft_LinkForPage.prototype.getData
=	function(){
	return {	"Text"					:	this._Text					,
				"Url"					:	this._Url					,
				"Target"				:	this._Target				};
}

/*--------------------------------------------------------------------------------
	データ設定
--------------------------------------------------------------------------------*/
Com_Kanasansoft_LinkForPage.prototype.setData
=	function(obj){
	this._Text					=	obj["Text"];
	this._Url					=	obj["Url"];
	this._Target				=	obj["Target"];
}

/*--------------------------------------------------------------------------------
	編集領域出力
--------------------------------------------------------------------------------*/
Com_Kanasansoft_LinkForPage.getEditAreaHTML
=	function(){
	var html			=	"";
	html				+=	"<div>";
	html				+=		"<div>";
	html				+=			"Text";
	html				+=		"</div>";
	html				+=		"<div>";
	html				+=			"<input type=\"text\" id=\"Com_Kanasansoft_LinkForPage_Text\" />";
	html				+=		"</div>";
	html				+=	"</div>";
	html				+=	"<div>";
	html				+=		"<div>";
	html				+=			"Url(ex. http://www.kanasansoft.com/)";
	html				+=		"</div>";
	html				+=		"<div>";
	html				+=			"<input type=\"text\" size=\"70\" id=\"Com_Kanasansoft_LinkForPage_Url\" />";
	html				+=		"</div>";
	html				+=	"</div>";
	html				+=	"<div>";
	html				+=		"<div>";
	html				+=			"Target";
	html				+=		"</div>";
	html				+=		"<div>";
	html				+=			"<input type=\"text\" id=\"Com_Kanasansoft_LinkForPage_Target\" />";
	html				+=		"</div>";
	html				+=	"</div>";
	return html;
}

/*--------------------------------------------------------------------------------
	編集領域からデータ取得
--------------------------------------------------------------------------------*/
Com_Kanasansoft_LinkForPage.prototype.getEditAreaData
=	function(){

	var obj						=	document.getElementById("Com_Kanasansoft_LinkForPage_Text");
	this._Text					=	obj.value;

	var obj						=	document.getElementById("Com_Kanasansoft_LinkForPage_Url");
	this._Url					=	obj.value;

	var obj						=	document.getElementById("Com_Kanasansoft_LinkForPage_Target");
	this._Target				=	obj.value;

}

/*--------------------------------------------------------------------------------
	編集領域にデータ設定
--------------------------------------------------------------------------------*/
Com_Kanasansoft_LinkForPage.prototype.setEditAreaData
=	function(){

	var obj						=	document.getElementById("Com_Kanasansoft_LinkForPage_Text");
	obj.value					=	this._Text;

	var obj						=	document.getElementById("Com_Kanasansoft_LinkForPage_Url");
	obj.value					=	this._Url;

	var obj						=	document.getElementById("Com_Kanasansoft_LinkForPage_Target");
	obj.value					=	this._Target;

}

/*--------------------------------------------------------------------------------
	HTML作成
--------------------------------------------------------------------------------*/
Com_Kanasansoft_LinkForPage.prototype.getHTML
=	function(){
	var html			=	"";
	html				+=	"<div class=\"Com_Kanasansoft_LinkForPage\">";
	html				+=		"<a";
	html				+=			" class=\"Link\"";
	html				+=			" href=\"";
	html				+=				StringUtility.Encode.HTML(this._Url);
	html				+=			"\"";
	if(this._Target!=""){
		html			+=			" target=\"";
		html			+=				StringUtility.Encode.HTML(this._Target);
		html			+=			"\"";
	}
	html				+=		">";
	html				+=			StringUtility.Encode.HTML(this._Text);
	html				+=		"</a>";
	html				+=	"</div>";
	return html;
}

/*--------------------------------------------------------------------------------
	テンプレート名取得
--------------------------------------------------------------------------------*/
Com_Kanasansoft_LinkForPage.getName
=	function(){
	return "Link For Page";
}

/*--------------------------------------------------------------------------------
	テンプレートID取得
--------------------------------------------------------------------------------*/
Com_Kanasansoft_LinkForPage.getId
=	function(){
	return "Com_Kanasansoft_LinkForPage";
}

//テンプレートを追加
addTemplate(Com_Kanasansoft_LinkForPage);
