﻿/*
================================================================================
	Name		:	Com_Kanasansoft_Image
	In			:	[none]		
	Out			:	[none]		
	Note		:	Kanasansoft Blog Editor用テンプレート
--------------------------------------------------------------------------------
	Version		:	Ver1.0.0	|	2006/12/13	|	新規作成
				:	Ver1.0.1	|	2006/12/13	|	スキーマ[http]を必須から任意へ変更
--------------------------------------------------------------------------------
	License		:	New BSD license
	URL			:	www.kanasansoft.com
================================================================================
*/

/*--------------------------------------------------------------------------------
	コンストラクタ
--------------------------------------------------------------------------------*/
function Com_Kanasansoft_Image(){
	this._ImageUrl				=	"http://";
	this._Title					=	"";
	this._UpperCaption			=	"";
	this._LowerCaption			=	"";
	this._LinkUrl				=	"";
	this._Target				=	"";
}

/*--------------------------------------------------------------------------------
	データ取得
--------------------------------------------------------------------------------*/
Com_Kanasansoft_Image.prototype.getData
=	function(){
	return {	"ImageUrl"				:	this._ImageUrl				,
				"Title"					:	this._Title					,
				"UpperCaption"			:	this._UpperCaption			,
				"LowerCaption"			:	this._LowerCaption			,
				"LinkUrl"				:	this._LinkUrl				,
				"Target"				:	this._Target				};
}

/*--------------------------------------------------------------------------------
	データ設定
--------------------------------------------------------------------------------*/
Com_Kanasansoft_Image.prototype.setData
=	function(obj){
	this._ImageUrl				=	obj["ImageUrl"];
	this._Title					=	obj["Title"];
	this._UpperCaption			=	obj["UpperCaption"];
	this._LowerCaption			=	obj["LowerCaption"];
	this._LinkUrl				=	obj["LinkUrl"];
	this._Target				=	obj["Target"];
}

/*--------------------------------------------------------------------------------
	編集領域出力
--------------------------------------------------------------------------------*/
Com_Kanasansoft_Image.getEditAreaHTML
=	function(){
	var html			=	"";
	html				+=	"<div>";
	html				+=		"<div>";
	html				+=			"Image Url(ex. http://www.kanasansoft.com/images/sample_s.jpg)";
	html				+=		"</div>";
	html				+=		"<div>";
	html				+=			"<input type=\"text\" size=\"70\" id=\"Com_Kanasansoft_Image_ImageUrl\" />";
	html				+=		"</div>";
	html				+=	"</div>";
	html				+=	"<div>";
	html				+=		"<div>";
	html				+=			"Title";
	html				+=		"</div>";
	html				+=		"<div>";
	html				+=			"<input type=\"text\" id=\"Com_Kanasansoft_Image_Title\" />";
	html				+=		"</div>";
	html				+=	"</div>";
	html				+=	"<div>";
	html				+=		"<div>";
	html				+=			"Upper Caption";
	html				+=		"</div>";
	html				+=		"<div>";
	html				+=			"<input type=\"text\" id=\"Com_Kanasansoft_Image_UpperCaption\" />";
	html				+=		"</div>";
	html				+=	"</div>";
	html				+=	"<div>";
	html				+=		"<div>";
	html				+=			"Lower Caption";
	html				+=		"</div>";
	html				+=		"<div>";
	html				+=			"<input type=\"text\" id=\"Com_Kanasansoft_Image_LowerCaption\" />";
	html				+=		"</div>";
	html				+=	"</div>";
	html				+=	"<div>";
	html				+=		"<div>";
	html				+=			"Link Url(ex. http://www.kanasansoft.com/images/sample.jpg)";
	html				+=		"</div>";
	html				+=		"<div>";
	html				+=			"<input type=\"text\" size=\"70\" id=\"Com_Kanasansoft_Image_LinkUrl\" />";
	html				+=		"</div>";
	html				+=	"</div>";
	html				+=	"<div>";
	html				+=		"<div>";
	html				+=			"Target";
	html				+=		"</div>";
	html				+=		"<div>";
	html				+=			"<input type=\"text\" id=\"Com_Kanasansoft_Image_Target\" />";
	html				+=		"</div>";
	html				+=	"</div>";
	return html;
}

/*--------------------------------------------------------------------------------
	編集領域からデータ取得
--------------------------------------------------------------------------------*/
Com_Kanasansoft_Image.prototype.getEditAreaData
=	function(){

	var obj						=	document.getElementById("Com_Kanasansoft_Image_ImageUrl");
	this._ImageUrl				=	obj.value;

	var obj						=	document.getElementById("Com_Kanasansoft_Image_Title");
	this._Title					=	obj.value;

	var obj						=	document.getElementById("Com_Kanasansoft_Image_UpperCaption");
	this._UpperCaption			=	obj.value;

	var obj						=	document.getElementById("Com_Kanasansoft_Image_LowerCaption");
	this._LowerCaption			=	obj.value;

	var obj						=	document.getElementById("Com_Kanasansoft_Image_LinkUrl");
	this._LinkUrl				=	obj.value;

	var obj						=	document.getElementById("Com_Kanasansoft_Image_Target");
	this._Target				=	obj.value;

}

/*--------------------------------------------------------------------------------
	編集領域にデータ設定
--------------------------------------------------------------------------------*/
Com_Kanasansoft_Image.prototype.setEditAreaData
=	function(){

	var obj						=	document.getElementById("Com_Kanasansoft_Image_ImageUrl");
	obj.value					=	this._ImageUrl;

	var obj						=	document.getElementById("Com_Kanasansoft_Image_Title");
	obj.value					=	this._Title;

	var obj						=	document.getElementById("Com_Kanasansoft_Image_UpperCaption");
	obj.value					=	this._UpperCaption;

	var obj						=	document.getElementById("Com_Kanasansoft_Image_LowerCaption");
	obj.value					=	this._LowerCaption;

	var obj						=	document.getElementById("Com_Kanasansoft_Image_LinkUrl");
	obj.value					=	this._LinkUrl;

	var obj						=	document.getElementById("Com_Kanasansoft_Image_Target");
	obj.value					=	this._Target;

}

/*--------------------------------------------------------------------------------
	HTML作成
--------------------------------------------------------------------------------*/
Com_Kanasansoft_Image.prototype.getHTML
=	function(){
	var html			=	"";
	html				+=	"<div class=\"Com_Kanasansoft_Image\">";

	if(this._UpperCaption!=""){
		html			+=		"<div class=\"UpperCaption\">";
		html			+=			StringUtility.Encode.HTML(this._UpperCaption);
		html			+=		"</div>";
	}
	html				+=		"<div class=\"Image\">";
	if(this._LinkUrl!=""){
		html			+=			"<a";
		html			+=				" class=\"Link\"";
		html			+=				" href=\"";
		html			+=					StringUtility.Encode.HTML(this._LinkUrl);
		html			+=				"\"";
		if(this._Target!=""){
			html		+=				" target=\"";
			html		+=					StringUtility.Encode.HTML(this._Target);
			html		+=				"\"";
		}
		html			+=			">";
	}
	html				+=				"<img";
	html				+=					" class=\"Image\"";
	html				+=					" src=\"";
	html				+=						StringUtility.Encode.HTML(this._ImageUrl);
	html				+=					"\"";
	if(this._Title!=""){
		html			+=					" alt=\"";
		html			+=						StringUtility.Encode.HTML(this._Title);
		html			+=					"\"";
		html			+=					" title=\"";
		html			+=						StringUtility.Encode.HTML(this._Title);
		html			+=					"\"";
	}
	html				+=				" />";
	if(this._LinkUrl!=""){
		html			+=			"</a>";
	}
	html				+=		"</div>";
	if(this._LowerCaption!=""){
		html			+=		"<div class=\"LowerCaption\">";
		html			+=			StringUtility.Encode.HTML(this._LowerCaption);
		html			+=		"</div>";
	}
	html				+=	"</div>";
	return html;
}

/*--------------------------------------------------------------------------------
	テンプレート名取得
--------------------------------------------------------------------------------*/
Com_Kanasansoft_Image.getName
=	function(){
	return "Image";
}

/*--------------------------------------------------------------------------------
	テンプレートID取得
--------------------------------------------------------------------------------*/
Com_Kanasansoft_Image.getId
=	function(){
	return "Com_Kanasansoft_Image";
}

//テンプレートを追加
addTemplate(Com_Kanasansoft_Image);
