﻿/*
================================================================================
	Name		:	SortUtility
	In			:	[none]		
	Out			:	[none]		
	Note		:	ソート用ユーティリティ群
--------------------------------------------------------------------------------
	Version		:	Ver1.0.0	|	2006/11/10	|	新規作成
--------------------------------------------------------------------------------
	License		:	New BSD license
	URL			:	www.kanasansoft.com
================================================================================
*/

/*--------------------------------------------------------------------------------
	コンストラクタ
--------------------------------------------------------------------------------*/
function SortUtility(){
}

/*--------------------------------------------------------------------------------
	昇降順チェック
--------------------------------------------------------------------------------*/
SortUtility._checkOrder
=	function(order){
	var rtn;
	if(		order				==	null				||
			order				==	undefined			||
			order.constructor	!=	Number				){
		rtn		=	1;
	}else{
		//値渡し
		rtn		=	Number(order);
	}
	return rtn;
}

/*--------------------------------------------------------------------------------
	ソート関数
--------------------------------------------------------------------------------*/
SortUtility.sort
=	function(a,b,order){

	var rtn;

	if(		a					==	null				||
			b					==	null				||
			a					==	undefined			||
			b					==	undefined			||
			a.constructor		!=	b.constructor		){
		rtn		=	SortUtility.sortForOther(a,b,order)
	}else{
		switch(a.constructor){
			case Boolean	:	rtn	=	SortUtility.sortForBoolean(	a,b,order	)	;	break	;
			case Number		:	rtn	=	SortUtility.sortForNumber(	a,b,order	)	;	break	;
			case Date		:	rtn	=	SortUtility.sortForDate(	a,b,order	)	;	break	;
			case String		:	rtn	=	SortUtility.sortForString(	a,b,order	)	;	break	;
			default			:	rtn	=	SortUtility.sortForOther(	a,b,order	)	;	break	;
		}
	}

	return rtn;

}

/*--------------------------------------------------------------------------------
	ソート関数(真偽値用)
--------------------------------------------------------------------------------*/
SortUtility.sortForBoolean
=	function(a,b,order){

	var odr		=	SortUtility._checkOrder(order);

	return odr*((a?1:0)-(b?1:0));

}

/*--------------------------------------------------------------------------------
	ソート関数(数値用)
--------------------------------------------------------------------------------*/
SortUtility.sortForNumber
=	function(a,b,order){

	var odr		=	SortUtility._checkOrder(order);

	return odr*(a-b);

}

/*--------------------------------------------------------------------------------
	ソート関数(日時)
--------------------------------------------------------------------------------*/
SortUtility.sortForDate
=	function(a,b,order){

	var odr		=	SortUtility._checkOrder(order);

	return odr*(a.getTime()-b.getTime());

}

/*--------------------------------------------------------------------------------
	ソート関数(文字列用)
--------------------------------------------------------------------------------*/
SortUtility.sortForString
=	function(a,b,order){

	var odr		=	SortUtility._checkOrder(order);

	var loop	=	Math.min(a.length,b.length);

	var rtn		=	a.length-b.length;

	for(var i=0;i<loop;i++){
		if(a.charCodeAt(i)!=b.charCodeAt(i)){
			rtn	=	a.charCodeAt(i)-b.charCodeAt(i);
			break;
		}
	}

	return odr*rtn;

}

/*--------------------------------------------------------------------------------
	ソート関数(その他用)
--------------------------------------------------------------------------------*/
SortUtility.sortForOther
=	function(a,b,order){

	var odr		=	SortUtility._checkOrder(order);

	//比較関数を使用しなかった場合の調査
	var ary		=	[a,b];
	ary			.	sort();

	//型を含めて厳密に比較しても
	//並び替えされていないかチェック
	return odr*(a===ary[0]?-1:1);

}
