﻿/*
================================================================================
	Name		:	BookmarkletCreator
	In			:	[none]		
	Out			:	[none]		
	Note		:	ブックマークレット作成用ユーティリティ群
--------------------------------------------------------------------------------
	Version		:	Ver1.0.0	|	2006/11/14	|	新規作成
--------------------------------------------------------------------------------
	License		:	New BSD license
	URL			:	www.kanasansoft.com
================================================================================
*/

/*--------------------------------------------------------------------------------
	コンストラクタ
--------------------------------------------------------------------------------*/
function BookmarkletCreator(){
}

/*--------------------------------------------------------------------------------
	外部ファイルJavaScriptを読み込むHTML生成
--------------------------------------------------------------------------------*/
BookmarkletCreator.makeHtmlWithExternalJavaScript
=	function(path,id){

	var html	=	"";

	html		+=	"<html>";
	html		+=		"<head>";
	html		+=			"<meta http-equiv=\"Content-Type\" content=\"text/html;charset=UTF-8\" />";
	html		+=			"<script";
	html		+=				" type=\"text/javascript\"";
	html		+=				" charset=\"UTF-8\"";
	html		+=				" src=\""+StringUtility.Encode.HTML(path)+"\"";
	html		+=			">";
	html		+=			"</script>";
	html		+=		"</head>";
	html		+=		"<body";
	html		+=			" id=\""+StringUtility.Encode.HTML(id)+"\"";
	html		+=		">";
	html		+=		"</body>";
	html		+=	"</html>";

	return	html;

}

/*--------------------------------------------------------------------------------
	指定したHTMLを新規ウィンドウで表示するJavaScript作成
--------------------------------------------------------------------------------*/
BookmarkletCreator.makeJavaScriptOpenNewWindow
=	function(html){

	var source	=	"";

	source		+=	"var s=window.open();";
	source		+=	"with(s.document){";
	source		+=		"open();";
	source		+=		"write(\""+StringUtility.Encode.JavaScript(html)+"\");";
	source		+=		"close()";
	source		+=	"}";

	return	source;

}

/*--------------------------------------------------------------------------------
	指定したJavaScriptを埋め込んだBookmarklet生成(リンク用)
--------------------------------------------------------------------------------*/
BookmarkletCreator.makeBookmarkletForLink
=	function(source){

	var link	=	"";

	link		+=	"javascript:";
	link		+=	"(";
	link		+=		"function(){";
	link		+=			source
	link		+=		"}";
	link		+=	")";
	link		+=	"()";

	return	link;

}

/*--------------------------------------------------------------------------------
	リンクを生成する
--------------------------------------------------------------------------------*/
BookmarkletCreator.makeLinkHtml
=	function(link,uri){

	var html	=	"";

	html		+=	"<a";
	html		+=		" href=\""+StringUtility.Encode.HTMLforBookmarklet(uri)+"\"";
	html		+=	">";
	html		+=		StringUtility.Encode.HTML(link);
	html		+=	"</a>";

	return	html;

}
