﻿/*
================================================================================
	Name		:	Com_Kanasansoft_Source
	In			:	[none]		
	Out			:	[none]		
	Note		:	Kanasansoft Blog Editor用テンプレート
--------------------------------------------------------------------------------
	Version		:	Ver1.0.0	|	2006/11/18	|	新規作成
				:	Ver1.1.0	|	2006/12/12	|	getIdの追加
				:				|				|	出力方法を選択できるように修正
--------------------------------------------------------------------------------
	License		:	New BSD license
	URL			:	www.kanasansoft.com
================================================================================
*/

/*--------------------------------------------------------------------------------
	コンストラクタ
--------------------------------------------------------------------------------*/
function Com_Kanasansoft_Source(){
	this._SourceForCopy			=	true;
	this._SourceForDisplay		=	true;
	this._TabLength				=	4;
	this._UpperCaption			=	"";
	this._LowerCaption			=	"";
	this._Source				=	"";
}

/*--------------------------------------------------------------------------------
	データ取得
--------------------------------------------------------------------------------*/
Com_Kanasansoft_Source.prototype.getData
=	function(){
	return {	"SourceForCopy"			:	this._SourceForCopy			,
				"SourceForDisplay"		:	this._SourceForDisplay		,
				"TabLength"				:	this._TabLength				,
				"UpperCaption"			:	this._UpperCaption			,
				"LowerCaption"			:	this._LowerCaption			,
				"Source"				:	this._Source				};
}

/*--------------------------------------------------------------------------------
	データ設定
--------------------------------------------------------------------------------*/
Com_Kanasansoft_Source.prototype.setData
=	function(obj){
	this._SourceForCopy			=	obj["SourceForCopy"];
	this._SourceForDisplay		=	obj["SourceForDisplay"];
	this._TabLength				=	obj["TabLength"];
	this._UpperCaption			=	obj["UpperCaption"];
	this._LowerCaption			=	obj["LowerCaption"];
	this._Source				=	obj["Source"];
}

/*--------------------------------------------------------------------------------
	編集領域出力
--------------------------------------------------------------------------------*/
Com_Kanasansoft_Source.getEditAreaHTML
=	function(){
	var html			=	"";
	html				+=	"<div>";
	html				+=		"<div>";
	html				+=			"Output";
	html				+=		"</div>";
	html				+=		"<div>";
	html				+=			"<input type=\"checkbox\" id=\"Com_Kanasansoft_Source_SourceForCopy\" /><label for=\"Com_Kanasansoft_Source_SourceForCopy\">Source For Copy</label>";
	html				+=			"<input type=\"checkbox\" id=\"Com_Kanasansoft_Source_SourceForDisplay\" /><label for=\"Com_Kanasansoft_Source_SourceForDisplay\">Source For Display</label>";
	html				+=		"</div>";
	html				+=	"</div>";
	html				+=	"<div>";
	html				+=		"<div>";
	html				+=			"Tab Length";
	html				+=		"</div>";
	html				+=		"<div>";
	html				+=			"<select id=\"Com_Kanasansoft_Source_TabLength\">";
	html				+=				"<option value=\"0\">0</option>";
	html				+=				"<option value=\"2\">2</option>";
	html				+=				"<option value=\"4\" selected=\"selected\">4</option>";
	html				+=				"<option value=\"8\">8</option>";
	html				+=			"</select>";
	html				+=		"</div>";
	html				+=	"</div>";
	html				+=	"<div>";
	html				+=		"<div>";
	html				+=			"Upper Caption";
	html				+=		"</div>";
	html				+=		"<div>";
	html				+=			"<input type=\"text\" id=\"Com_Kanasansoft_Source_UpperCaption\" />";
	html				+=		"</div>";
	html				+=	"</div>";
	html				+=	"<div>";
	html				+=		"<div>";
	html				+=			"Source";
	html				+=		"</div>";
	html				+=		"<div>";
	html				+=			"<textarea cols=\"60\" rows=\"14\" id=\"Com_Kanasansoft_Source_Source\">";
	html				+=			"</textarea>";
	html				+=		"</div>";
	html				+=	"</div>";
	html				+=	"<div>";
	html				+=		"<div>";
	html				+=			"Lower Caption";
	html				+=		"</div>";
	html				+=		"<div>";
	html				+=			"<input type=\"text\" id=\"Com_Kanasansoft_Source_LowerCaption\" />";
	html				+=		"</div>";
	html				+=	"</div>";
	return html;
}

/*--------------------------------------------------------------------------------
	編集領域からデータ取得
--------------------------------------------------------------------------------*/
Com_Kanasansoft_Source.prototype.getEditAreaData
=	function(){

	var obj						=	document.getElementById("Com_Kanasansoft_Source_SourceForCopy");
	this._SourceForCopy			=	obj.checked;

	var obj						=	document.getElementById("Com_Kanasansoft_Source_SourceForDisplay");
	this._SourceForDisplay		=	obj.checked;

	var obj						=	document.getElementById("Com_Kanasansoft_Source_TabLength");
	obj.selectedIndex			=	(obj.selectedIndex==-1?0:obj.selectedIndex);
	this._TabLength				=	Number(obj.options[obj.selectedIndex].value);

	var obj						=	document.getElementById("Com_Kanasansoft_Source_UpperCaption");
	this._UpperCaption			=	obj.value;

	var obj						=	document.getElementById("Com_Kanasansoft_Source_LowerCaption");
	this._LowerCaption			=	obj.value;

	var obj						=	document.getElementById("Com_Kanasansoft_Source_Source");
	this._Source				=	obj.value;

}

/*--------------------------------------------------------------------------------
	編集領域にデータ設定
--------------------------------------------------------------------------------*/
Com_Kanasansoft_Source.prototype.setEditAreaData
=	function(){

	var obj						=	document.getElementById("Com_Kanasansoft_Source_SourceForCopy");
	obj.checked					=	this._SourceForCopy;

	var obj						=	document.getElementById("Com_Kanasansoft_Source_SourceForDisplay");
	obj.checked					=	this._SourceForDisplay;

	var obj						=	document.getElementById("Com_Kanasansoft_Source_TabLength");
	for(var i=0;i<obj.options.length;i++){
		if(Number(obj.options[i].value)==this._TabLength){
			obj.options.selectedIndex	=	i;
		}
	}

	var obj						=	document.getElementById("Com_Kanasansoft_Source_UpperCaption");
	obj.value					=	this._UpperCaption;

	var obj						=	document.getElementById("Com_Kanasansoft_Source_LowerCaption");
	obj.value					=	this._LowerCaption;

	var obj						=	document.getElementById("Com_Kanasansoft_Source_Source");
	obj.value					=	this._Source;

}

/*--------------------------------------------------------------------------------
	HTML作成
--------------------------------------------------------------------------------*/
Com_Kanasansoft_Source.prototype.getHTML
=	function(){
	var html			=	"";
	html				+=	"<div class=\"Com_Kanasansoft_Source\">";
	if(this._UpperCaption!=""){
		html			+=		"<div class=\"UpperCaption\">";
		html			+=			StringUtility.Encode.HTML(this._UpperCaption);
		html			+=		"</div>";
	}
	if(this._SourceForCopy){
		html			+=		"<div class=\"SourceForCopy\">";
		html			+=			"<textarea";
		html			+=				" class=\"SourceForCopy\"";
		html			+=				" wrap=\"off\"";
		html			+=				" onclick=\"this.select();\"";
		html			+=				" onkeyup=\"this.select();\"";
		html			+=				" onfocus=\"this.select();\"";
		html			+=				" readonly=\"readonly\"";
		html			+=				" title=\"It is the source for copy. If here is clicked, all sources are selected.\"";
		html			+=			">";
		html			+=				StringUtility.Encode.HTML(this._Source);
		html			+=			"</textarea>";
		html			+=		"</div>";
	}
	if(this._SourceForDisplay){
		html			+=		"<div";
		html			+=			" class=\"SourceForDisplay\"";
		html			+=			" title=\"It is the source for display. It is edited to one for display.\"";
		html			+=		">";
		html			+=			StringUtility.Convert.NewLineCodeToTag(
										StringUtility.Encode.HTML(
											StringUtility.Convert.TabToSpace(this._Source,this._TabLength)
										)
									);
		html			+=		"</div>";
	}
	if(this._LowerCaption!=""){
		html			+=		"<div class=\"LowerCaption\">";
		html			+=			StringUtility.Encode.HTML(this._LowerCaption);
		html			+=		"</div>";
	}
	html				+=	"</div>";
	return html;
}

/*--------------------------------------------------------------------------------
	テンプレート名取得
--------------------------------------------------------------------------------*/
Com_Kanasansoft_Source.getName
=	function(){
	return "Source";
}

/*--------------------------------------------------------------------------------
	テンプレートID取得
--------------------------------------------------------------------------------*/
Com_Kanasansoft_Source.getId
=	function(){
	return "Com_Kanasansoft_Source";
}

//テンプレートを追加
addTemplate(Com_Kanasansoft_Source);
