﻿/*
================================================================================
	Name		:	Com_Kanasansoft_PlainText
	In			:	[none]		
	Out			:	[none]		
	Note		:	Kanasansoft Blog Editor用テンプレート
--------------------------------------------------------------------------------
	Version		:	Ver1.0.0	|	2006/11/18	|	新規作成
				:	Ver1.1.0	|	2006/12/12	|	getIdの追加
				:	Ver1.2.0	|	2006/12/12	|	項目[Title]の追加
--------------------------------------------------------------------------------
	License		:	New BSD license
	URL			:	www.kanasansoft.com
================================================================================
*/

/*--------------------------------------------------------------------------------
	コンストラクタ
--------------------------------------------------------------------------------*/
function Com_Kanasansoft_PlainText(){
	this._Title					=	"";
	this._PlainText				=	"";
}

/*--------------------------------------------------------------------------------
	データ取得
--------------------------------------------------------------------------------*/
Com_Kanasansoft_PlainText.prototype.getData
=	function(){
	return {	"Title"					:	this._Title					,
				"PlainText"				:	this._PlainText				};
}

/*--------------------------------------------------------------------------------
	データ設定
--------------------------------------------------------------------------------*/
Com_Kanasansoft_PlainText.prototype.setData
=	function(obj){
	this._Title					=	obj["Title"];
	this._PlainText				=	obj["PlainText"];
}

/*--------------------------------------------------------------------------------
	編集領域出力
--------------------------------------------------------------------------------*/
Com_Kanasansoft_PlainText.getEditAreaHTML
=	function(){
	var html			=	"";
	html				+=	"<div>";
	html				+=		"<div>";
	html				+=			"Title";
	html				+=		"</div>";
	html				+=		"<div>";
	html				+=			"<input type=\"text\" id=\"Com_Kanasansoft_PlainText_Title\" />";
	html				+=		"</div>";
	html				+=	"</div>";
	html				+=	"<div>";
	html				+=		"<div>";
	html				+=			"Plain Text";
	html				+=		"</div>";
	html				+=		"<div>";
	html				+=			"<textarea cols=\"60\" rows=\"20\" id=\"Com_Kanasansoft_PlainText_Text\">";
	html				+=			"</textarea>";
	html				+=		"</div>";
	html				+=	"</div>";
	return html;
}

/*--------------------------------------------------------------------------------
	編集領域からデータ取得
--------------------------------------------------------------------------------*/
Com_Kanasansoft_PlainText.prototype.getEditAreaData
=	function(){

	var obj						=	document.getElementById("Com_Kanasansoft_PlainText_Title");
	this._Title					=	obj.value;

	var obj						=	document.getElementById("Com_Kanasansoft_PlainText_Text");
	this._PlainText				=	obj.value;

}

/*--------------------------------------------------------------------------------
	編集領域にデータ設定
--------------------------------------------------------------------------------*/
Com_Kanasansoft_PlainText.prototype.setEditAreaData
=	function(){

	var obj						=	document.getElementById("Com_Kanasansoft_PlainText_Title");
	obj.value					=	this._Title;

	var obj						=	document.getElementById("Com_Kanasansoft_PlainText_Text");
	obj.value					=	this._PlainText;

}


/*--------------------------------------------------------------------------------
	HTML作成
--------------------------------------------------------------------------------*/
Com_Kanasansoft_PlainText.prototype.getHTML
=	function(){
	var html			=	"";
	html				+=	"<div class=\"Com_Kanasansoft_PlainText\">";
	if(this._Title!=""){
		html			+=		"<div class=\"Title\">";
		html			+=			"<h5>";
		html			+=				StringUtility.Encode.HTML(this._Title);
		html			+=			"</h5>";
		html			+=		"</div>";
	}
	html				+=		"<div class=\"PlainText\">";
	html				+=			StringUtility.Convert.NewLineCodeToTag(
										StringUtility.Encode.HTML(this._PlainText)
									);
	html				+=		"</div>";
	html				+=	"</div>";
	return html;
}

/*--------------------------------------------------------------------------------
	テンプレート名取得
--------------------------------------------------------------------------------*/
Com_Kanasansoft_PlainText.getName
=	function(){
	return "Plain Text";
}

/*--------------------------------------------------------------------------------
	テンプレートID取得
--------------------------------------------------------------------------------*/
Com_Kanasansoft_PlainText.getId
=	function(){
	return "Com_Kanasansoft_PlainText";
}

//テンプレートを追加
addTemplate(Com_Kanasansoft_PlainText);
