﻿/*
================================================================================
	Name		:	Bookmarkletから呼ばれる外部ファイルJavaScript
	In			:	[none]		
	Out			:	[none]		
	Note		:	DynamicLoadControllerを使用し
					更に外部ファイルJavaScriptを動的に読み込む
--------------------------------------------------------------------------------
	Version		:	Ver1.0.0	|	2006/11/18	|	新規作成
--------------------------------------------------------------------------------
	License		:	New BSD license
	URL			:	www.kanasansoft.com
================================================================================
*/

/*--------------------------------------------------------------------------------
	定数
--------------------------------------------------------------------------------*/
//動的に読み込まれる外部ファイルの親ディレクトリ
var KANASANSOFT_FOLDER_PATH	=	"http://localhost/Kanasansoft/";

//動的に読み込まれる外部ファイルJavaScript
var DYNAMIC_LOAD_FILE_PATHS			=	[];
DYNAMIC_LOAD_FILE_PATHS				.	push(	"Library/JSON.js"									);
DYNAMIC_LOAD_FILE_PATHS				.	push(	"Library/StringUtility.js"							);
DYNAMIC_LOAD_FILE_PATHS				.	push(	"Library/MessageDigest.js"							);
DYNAMIC_LOAD_FILE_PATHS				.	push(	"Bookmarklet/BlogEditor/commonInitial.js"			);
DYNAMIC_LOAD_FILE_PATHS				.	push(	"Bookmarklet/BlogEditor/BookmarkletInitial.js"		);
DYNAMIC_LOAD_FILE_PATHS				.	push(	"Bookmarklet/BlogEditor/Bookmarklet.js"				);

//全外部ファイル読込完了後に呼ばれる処理
var COMPLETE_LOAD_ALL_FILE			=	function(){start();};

//強制的実行までの遅延時間
//	外部ファイルで定義したJavaScriptを動的に読み込む際
//	scriptタグにonloadイベントを定義しても実行されないブラウザが存在する
//	このようなブラウザを使用する場合、タイマーイベントで強制的に実行させる
//	タイマーによる強制実行を行わせない場合は[0]を設定
//	環境にもよるが[500~1000]位が適当と思われる
var FORCEFUL_RUNNING_MILLISECOND	=	1000;

/*--------------------------------------------------------------------------------
	初期処理
--------------------------------------------------------------------------------*/
function initial(){
	new DynamicLoadController(KANASANSOFT_FOLDER_PATH,DYNAMIC_LOAD_FILE_PATHS,COMPLETE_LOAD_ALL_FILE);
}

/*--------------------------------------------------------------------------------
	DynamicLoadController
--------------------------------------------------------------------------------*/
function DynamicLoadController(path,files,complete){

	//全読込完了後に呼ばれる処理を記憶
	this._complete	=	complete;

	//読み込まれる外部ファイル数を記憶
	this._count	=	files.length;

	//指定された外部ファイルパスを順に処理
	for(var i=0;i<files.length;i++){
		this._load(path+files[i]);
	}

	//強制的な遅延実行
	if(FORCEFUL_RUNNING_MILLISECOND>0){
		window.setTimeout(this._complete,FORCEFUL_RUNNING_MILLISECOND);
	}

}

/*--------------------------------------------------------------------------------
	外部ファイルを動的に読み込む
		onloadに読込完了時処理を定義
--------------------------------------------------------------------------------*/
DynamicLoadController.prototype._load
=	function(uri){
	var s		=	document.createElement("script");
	s.charset	=	"UTF-8";
	s.src		=	uri+"?time="+((new Date()).getTime().toString(16));
	s.onload	=	this._loaded;
	document.body.appendChild(s);
}

/*--------------------------------------------------------------------------------
	外部ファイル読込完了時処理
		ファイル読込完了毎に呼ばれる
		読込完了数をデクリメント
		全ファイル読込時に次の処理開始
--------------------------------------------------------------------------------*/
DynamicLoadController.prototype._loaded
=	function(uri){
	this._count--;
	if(this._count==0){
		this._complete();
	}
}

window.onload=initial;
