﻿/*
================================================================================
	Name		:	Com_Kanasansoft_Bookmarklet
	In			:	[none]		
	Out			:	[none]		
	Note		:	Kanasansoft Blog Editor用テンプレート
--------------------------------------------------------------------------------
	Version		:	Ver1.0.0	|	2006/12/02	|	新規作成
				:	Ver1.1.0	|	2006/12/12	|	getIdの追加
				:				|				|	出力方法を選択できるように修正
--------------------------------------------------------------------------------
	License		:	New BSD license
	URL			:	www.kanasansoft.com
================================================================================
*/

/*--------------------------------------------------------------------------------
	コンストラクタ
--------------------------------------------------------------------------------*/
function Com_Kanasansoft_Bookmarklet(){
	this._Name					=	"";
	this._SourceForCopy			=	true;
	this._SourceForDisplay		=	true;
	this._TabLength				=	4;
	this._Header				=	"";
	this._Source				=	"";
}

/*--------------------------------------------------------------------------------
	データ取得
--------------------------------------------------------------------------------*/
Com_Kanasansoft_Bookmarklet.prototype.getData
=	function(){
	return {	"Name"					:	this._Name					,
				"SourceForCopy"			:	this._SourceForCopy			,
				"SourceForDisplay"		:	this._SourceForDisplay		,
				"TabLength"				:	this._TabLength				,
				"Header"				:	this._Header				,
				"Source"				:	this._Source				};
}

/*--------------------------------------------------------------------------------
	データ設定
--------------------------------------------------------------------------------*/
Com_Kanasansoft_Bookmarklet.prototype.setData
=	function(obj){
	this._Name					=	obj["Name"];
	this._SourceForCopy			=	obj["SourceForCopy"];
	this._SourceForDisplay		=	obj["SourceForDisplay"];
	this._TabLength				=	obj["TabLength"];
	this._Header				=	obj["Header"];
	this._Source				=	obj["Source"];
}

/*--------------------------------------------------------------------------------
	編集領域出力
--------------------------------------------------------------------------------*/
Com_Kanasansoft_Bookmarklet.getEditAreaHTML
=	function(){
	var html			=	"";
	html				+=	"<div>";
	html				+=		"<div>";
	html				+=			"Name";
	html				+=		"</div>";
	html				+=		"<div>";
	html				+=			"<input type=\"text\" id=\"Com_Kanasansoft_Bookmarklet_Name\" />";
	html				+=		"</div>";
	html				+=	"</div>";
	html				+=	"<div>";
	html				+=		"<div>";
	html				+=			"Output";
	html				+=		"</div>";
	html				+=		"<div>";
	html				+=			"<input type=\"checkbox\" id=\"Com_Kanasansoft_Bookmarklet_SourceForCopy\" /><label for=\"Com_Kanasansoft_Bookmarklet_SourceForCopy\">Source For Copy</label>";
	html				+=			"<input type=\"checkbox\" id=\"Com_Kanasansoft_Bookmarklet_SourceForDisplay\" /><label for=\"Com_Kanasansoft_Bookmarklet_SourceForDisplay\">Source For Display</label>";
	html				+=		"</div>";
	html				+=	"</div>";
	html				+=	"<div>";
	html				+=		"<div>";
	html				+=			"Tab Length";
	html				+=		"</div>";
	html				+=		"<div>";
	html				+=			"<select id=\"Com_Kanasansoft_Bookmarklet_TabLength\">";
	html				+=				"<option value=\"0\">0</option>";
	html				+=				"<option value=\"2\">2</option>";
	html				+=				"<option value=\"4\" selected=\"selected\">4</option>";
	html				+=				"<option value=\"8\">8</option>";
	html				+=			"</select>";
	html				+=		"</div>";
	html				+=	"</div>";
	html				+=	"<div>";
	html				+=		"<div>";
	html				+=			"Header";
	html				+=		"</div>";
	html				+=		"<div>";
	html				+=			"<textarea cols=\"60\" rows=\"3\" id=\"Com_Kanasansoft_Bookmarklet_Header\">";
	html				+=			"</textarea>";
	html				+=		"</div>";
	html				+=	"</div>";
	html				+=	"<div>";
	html				+=		"<div>";
	html				+=			"Source";
	html				+=		"</div>";
	html				+=		"<div>";
	html				+=			"<textarea cols=\"60\" rows=\"12\" id=\"Com_Kanasansoft_Bookmarklet_Source\">";
	html				+=			"</textarea>";
	html				+=		"</div>";
	html				+=	"</div>";
	return html;
}

/*--------------------------------------------------------------------------------
	編集領域からデータ取得
--------------------------------------------------------------------------------*/
Com_Kanasansoft_Bookmarklet.prototype.getEditAreaData
=	function(){

	var obj						=	document.getElementById("Com_Kanasansoft_Bookmarklet_Name");
	this._Name					=	obj.value;

	var obj						=	document.getElementById("Com_Kanasansoft_Bookmarklet_SourceForCopy");
	this._SourceForCopy			=	obj.checked;

	var obj						=	document.getElementById("Com_Kanasansoft_Bookmarklet_SourceForDisplay");
	this._SourceForDisplay		=	obj.checked;

	var obj						=	document.getElementById("Com_Kanasansoft_Bookmarklet_TabLength");
	obj.selectedIndex			=	(obj.selectedIndex==-1?0:obj.selectedIndex);
	this._TabLength				=	Number(obj.options[obj.selectedIndex].value);

	var obj						=	document.getElementById("Com_Kanasansoft_Bookmarklet_Header");
	this._Header				=	obj.value;

	var obj						=	document.getElementById("Com_Kanasansoft_Bookmarklet_Source");
	this._Source				=	obj.value;

}

/*--------------------------------------------------------------------------------
	編集領域にデータ設定
--------------------------------------------------------------------------------*/
Com_Kanasansoft_Bookmarklet.prototype.setEditAreaData
=	function(){

	var obj						=	document.getElementById("Com_Kanasansoft_Bookmarklet_Name");
	obj.value					=	this._Name;

	var obj						=	document.getElementById("Com_Kanasansoft_Bookmarklet_SourceForCopy");
	obj.checked					=	this._SourceForCopy;

	var obj						=	document.getElementById("Com_Kanasansoft_Bookmarklet_SourceForDisplay");
	obj.checked					=	this._SourceForDisplay;

	var obj						=	document.getElementById("Com_Kanasansoft_Bookmarklet_TabLength");
	for(var i=0;i<obj.options.length;i++){
		if(Number(obj.options[i].value)==this._TabLength){
			obj.options.selectedIndex	=	i;
		}
	}

	var obj						=	document.getElementById("Com_Kanasansoft_Bookmarklet_Header");
	obj.value					=	this._Header;

	var obj						=	document.getElementById("Com_Kanasansoft_Bookmarklet_Source");
	obj.value					=	this._Source;

}

/*--------------------------------------------------------------------------------
	HTML作成
--------------------------------------------------------------------------------*/
Com_Kanasansoft_Bookmarklet.prototype.getHTML
=	function(){
	var html			=	"";
	html				+=	"<div class=\"Com_Kanasansoft_Bookmarklet\">";
	html				+=		"<div class=\"Link\">";
	html				+=			"<a";
	html				+=				" class=\"Link\"";
	html				+=				" href=\"javascript:";
	html				+=					StringUtility.Encode.HTMLforBookmarklet(this._Source);
	html				+=				"\"";
	html				+=			">";
	html				+=				StringUtility.Encode.HTML(this._Name);
	html				+=			"</a>";
	html				+=		"</div>";
	if(this._SourceForCopy){
		html			+=		"<div class=\"SourceForCopy\">";
		html			+=			"<textarea";
		html			+=				" class=\"SourceForCopy\"";
		html			+=				" wrap=\"off\"";
		html			+=				" onclick=\"this.select();\"";
		html			+=				" onkeyup=\"this.select();\"";
		html			+=				" onfocus=\"this.select();\"";
		html			+=				" readonly=\"readonly\"";
		html			+=				" title=\"It is the source for copy. If here is clicked, all sources are selected.\"";
		html			+=			">";
		html			+=				StringUtility.Encode.HTML(this._Header+"\n"+this._Source);
		html			+=			"</textarea>";
		html			+=		"</div>";
	}
	if(this._SourceForDisplay){
		html			+=		"<div";
		html			+=			" class=\"SourceForDisplay\"";
		html			+=			" title=\"It is the source for display. It is edited to one for display.\"";
		html			+=		">";
		html			+=			StringUtility.Convert.NewLineCodeToTag(
										StringUtility.Encode.HTML(
											StringUtility.Convert.TabToSpace(this._Header+"\n"+this._Source,this._TabLength)
										)
									);
		html			+=		"</div>";
	}
	html				+=	"</div>";
	return html;
}

/*--------------------------------------------------------------------------------
	テンプレート名取得
--------------------------------------------------------------------------------*/
Com_Kanasansoft_Bookmarklet.getName
=	function(){
	return "Bookmarklet";
}

/*--------------------------------------------------------------------------------
	テンプレートID取得
--------------------------------------------------------------------------------*/
Com_Kanasansoft_Bookmarklet.getId
=	function(){
	return "Com_Kanasansoft_Bookmarklet";
}

//テンプレートを追加
addTemplate(Com_Kanasansoft_Bookmarklet);
