﻿/*
================================================================================
	Name		:	Bookmarklet本体処理
	In			:	[none]		
	Out			:	[none]		
	Note		:	
--------------------------------------------------------------------------------
	Version		:	Ver1.0.0	|	2006/11/18	|	新規作成
				:	Ver1.1.0	|	2006/12/12	|	テンプレートを名前ではなく
				:				|				|	IDで管理するように修正
				:	Ver1.1.0	|	2006/12/14	|	テンプレートを名前ではなく
				:				|				|	IDで管理するように修正
--------------------------------------------------------------------------------
	License		:	New BSD license
	URL			:	www.kanasansoft.com
================================================================================
*/

var blogEditorData	=	{	"items"				:	[]	,
							"templatesOrder"	:	[]	,
							"templatesData"		:	{}	};

/*--------------------------------------------------------------------------------
	全外部ファイル読込完了時処理
--------------------------------------------------------------------------------*/
function start(){

	//画面生成
	document.getElementById(NEW_WINDOW_BODY_ID).innerHTML			=	makeHTMLBlogEditer();
	document.title													=	"Bookmarklet "+BOOKMARKLET_NAME+" "+BOOKMARKLET_VERSION;

	//テンプレートのパスを別配列に格納
	//(Operaでは何故かこうしないと配列が初期化され動かない為)
	var paths	=	[];
	for(var i=0;i<TEMPLATE_FILE_PATHS.length;i++){
		paths.push(TEMPLATE_FILE_PATHS[i]);
	}

	//テンプレート読込
	for(var i=0;i<paths.length;i++){
		loadByDynamic(paths[i]);
	}

	//イベント設定
	document.getElementById("blog_editor_templates").ondblclick		=	addItem;
	document.getElementById("blog_editor_templates_add").onclick	=	addItem;
	document.getElementById("blog_editor_items_up").onclick			=	moveItemUpper;
	document.getElementById("blog_editor_items_down").onclick		=	moveItemLower;
	document.getElementById("blog_editor_items_delete").onclick		=	deleteItem;
	document.getElementById("blog_editor_items").onchange			=	displayEditArea;
	document.getElementById("edit_area_memorize").onclick			=	memorizeEditArea;
	document.getElementById("edit_area_recollect").onclick			=	recollectEditArea;
	document.getElementById("edit_area_initialize").onclick			=	initializeEditArea;
	document.getElementById("blog_editor_import").onclick			=	importData;
	document.getElementById("blog_editor_export").onclick			=	exportData;

	displayTarget();

}

/*--------------------------------------------------------------------------------
	外部ファイルを動的に読み込む
--------------------------------------------------------------------------------*/
function loadByDynamic(uri){
	var s		=	document.createElement("script");
	s.charset	=	"UTF-8";
	s.src		=	uri+"?time="+((new Date()).getTime().toString(16));
	document.body.appendChild(s);
}

/*--------------------------------------------------------------------------------
	画面生成
--------------------------------------------------------------------------------*/
function makeHTMLBlogEditer(){

	var html	=	"";

	html		+=	"<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" style=\"font-family:monospace;font-size:12px;\">";
	html		+=		"<tr>";
	html		+=			"<td style=\"vertical-align:top;\">";
	html		+=				"<div style=\"border:2px outset #cccccc;background-color:#cccccc;margin:2px;padding:2px;\">";
	html		+=					"<div>";
	html		+=						"Template List";
	html		+=					"</div>";
	html		+=					"<div>";
	html		+=						"<button id=\"blog_editor_templates_add\">add</button>";
	html		+=					"</div>";
	html		+=					"<div style=\"border:2px inset #cccccc;background-color:#cccccc;margin:2px;padding:2px;\">";
	html		+=						"<select id=\"blog_editor_templates\" size=\"25\"></select>";
	html		+=					"</div>";
	html		+=				"</div>";
	html		+=			"</td>";
	html		+=			"<td style=\"vertical-align:top;\">";
	html		+=				"<div style=\"border:2px outset #cccccc;background-color:#cccccc;margin:2px;padding:2px;\">";
	html		+=					"<div>";
	html		+=						"Item List";
	html		+=					"</div>";
	html		+=					"<div>";
	html		+=						"<button id=\"blog_editor_items_up\">up</button>";
	html		+=						"<button id=\"blog_editor_items_down\">down</button>";
	html		+=						"<button id=\"blog_editor_items_delete\">delete</button>";
	html		+=					"</div>";
	html		+=					"<div style=\"border:2px inset #cccccc;background-color:#cccccc;margin:2px;padding:2px;\">";
	html		+=						"<select id=\"blog_editor_items\" size=\"25\"></select>";
	html		+=					"</div>";
	html		+=				"</div>";
	html		+=			"</td>";
	html		+=			"<td style=\"vertical-align:top;\">";
	html		+=				"<div style=\"border:2px outset #cccccc;background-color:#cccccc;margin:2px;padding:2px;\">";
	html		+=					"<div>";
	html		+=						"Edit Area";
	html		+=					"</div>";
	html		+=					"<div>";
	html		+=						"<button id=\"edit_area_initialize\">initial</button>";
	html		+=						"<button id=\"edit_area_recollect\">recollect</button>";
	html		+=						"<button id=\"edit_area_memorize\" style=\"font-weight:bold;\">memorize</button>";
	html		+=					"</div>";
	html		+=					"<div id=\"edit_area\" style=\"border:2px inset #cccccc;background-color:#cccccc;margin:2px;padding:2px;\">";
	html		+=					"</div>";
	html		+=				"</div>";
	html		+=			"</td>";
	html		+=		"</tr>";
	html		+=		"<tr>";
	html		+=			"<td colspan=\"3\" style=\"vertical-align:top;\">";
	html		+=				"<div style=\"border:2px outset #cccccc;background-color:#cccccc;margin:2px;padding:2px;\">";
	html		+=					"<div>";
	html		+=						"<select id=\"blog_editor_target\"></select>";
	html		+=						"<button id=\"blog_editor_import\">import</button>";
	html		+=						"<button id=\"blog_editor_export\">export</button>";
	html		+=					"</div>";
	html		+=				"</div>";
	html		+=			"</td>";
	html		+=		"</tr>";
	html		+=	"</table>";

	return html;

}

/*--------------------------------------------------------------------------------
	テンプレート追加
		各テンプレート読込終了時に呼ばれる
--------------------------------------------------------------------------------*/
function addTemplate(temp){

	//テンプレート追加
	blogEditorData.templatesOrder					.	push(temp.getId());
	blogEditorData.templatesData[temp.getId()]		=	temp;

	//全テンプレート読込完了
	if(TEMPLATE_FILE_PATHS.length		=	blogEditorData.templatesOrder.length){
		displayTemplates();
	}

}

/*--------------------------------------------------------------------------------
	テンプレート一覧表示
--------------------------------------------------------------------------------*/
function displayTemplates(){

	var opt		=	[];

	//テンプレート一覧用オプションタグ生成
	for(var i=0;i<blogEditorData.templatesOrder.length;i++){
		opt[i]			=	new Option();
		opt[i].value	=	blogEditorData.templatesOrder[i];
		opt[i].text		=	blogEditorData.templatesData[blogEditorData.templatesOrder[i]].getName();
	}

	//オプションタグを名前でソート
	opt.sort(
		function(a,b){
			var textA	=	a.text;
			var textB	=	b.text;
			for(var i=0;i<Math.min(textA.length,textB.length);i++){
				if(textA.charCodeAt(i)!=textB.charCodeAt(i)){
					return textA.charCodeAt(i)-textB.charCodeAt(i);
				}
			}
			return textA.length-textB.length;
		}
	);

	//テンプレート一覧にオプションタグ反映
	var obj						=	document.getElementById("blog_editor_templates");
	obj.options.length			=	opt.length;
	for(var i=0;i<opt.length;i++){
		obj.options[i]			=	opt[i];
	}
	obj.options.selectedIndex	=	-1;

}

/*--------------------------------------------------------------------------------
	アイテム一覧表示
--------------------------------------------------------------------------------*/
function displayItems(){

	var opt		=	[];

	//アイテム一覧用オプションタグ生成
	for(var i=0;i<blogEditorData.items.length;i++){
		opt[i]			=	new Option();
		opt[i].value	=	i.toString(16);
		opt[i].text		=	blogEditorData.items[i].constructor.getName();
	}

	//アイテム一覧にオプションタグ反映
	var obj						=	document.getElementById("blog_editor_items");
	obj.options.length			=	opt.length;
	for(var i=0;i<opt.length;i++){
		obj.options[i]			=	opt[i];
	}
	obj.options.selectedIndex	=	-1;

	displayEditArea();

}

/*--------------------------------------------------------------------------------
	ターゲット一覧表示
--------------------------------------------------------------------------------*/
function displayTarget(){

	var opt		=	[];

	//ターゲット一覧用オプションタグ生成
	for(var key in TARGET_TEXTAREA_ID){
		if(TARGET_TEXTAREA_ID.hasOwnProperty(key)){
			var i			=	opt.length;
			opt[i]			=	new Option();
			opt[i].value	=	TARGET_TEXTAREA_ID[key];
			opt[i].text		=	key;
		}
	}

	//ターゲット一覧にオプションタグ反映
	var obj						=	document.getElementById("blog_editor_target");
	obj.options.length			=	opt.length;
	for(var i=0;i<opt.length;i++){
		obj.options[i]			=	opt[i];
	}
	obj.options.selectedIndex	=	-1;

}

/*--------------------------------------------------------------------------------
	アイテム追加
--------------------------------------------------------------------------------*/
function addItem(){

	var obj	=	document.getElementById("blog_editor_templates");

	//未選択
	if(obj.options.selectedIndex==-1){
		return;
	}

	//実処理
	var templateId		=	obj.options[obj.options.selectedIndex].value;
	blogEditorData.items.push(new blogEditorData.templatesData[templateId]);
	displayItems();

}

/*--------------------------------------------------------------------------------
	エディットエリア表示
--------------------------------------------------------------------------------*/
function displayEditArea(){

	var obj	=	document.getElementById("blog_editor_items");

	//未選択
	if(obj.options.selectedIndex==-1){
		//初期化
		document.getElementById("edit_area").innerHTML	=	"";
		return;
	}

	//実処理
	var itemOrder		=	Number(obj.options[obj.options.selectedIndex].value);
	document.getElementById("edit_area").innerHTML	=	blogEditorData.items[itemOrder].constructor.getEditAreaHTML();
	blogEditorData.items[itemOrder].setEditAreaData();

}

/*--------------------------------------------------------------------------------
	アイテムを上に移動
--------------------------------------------------------------------------------*/
function moveItemUpper(){

	var obj	=	document.getElementById("blog_editor_items");

	//未選択
	if(obj.options.selectedIndex==-1){
		return;
	}

	//移動先なし
	if(obj.options.selectedIndex==0){
		return;
	}

	//実処理
	var itemOrder				=	Number(obj.options[obj.options.selectedIndex].value);
	blogEditorData.items		=	([])													.
									concat(	blogEditorData.items.slice(0,itemOrder-1)	)	.
									concat(	blogEditorData.items[itemOrder]				)	.
									concat(	blogEditorData.items[itemOrder-1]			)	.
									concat(	blogEditorData.items.slice(itemOrder+1)		)	;
	displayItems();
	obj.options.selectedIndex	=	itemOrder-1;
	displayEditArea();

}

/*--------------------------------------------------------------------------------
	アイテムを下に移動
--------------------------------------------------------------------------------*/
function moveItemLower(){

	var obj	=	document.getElementById("blog_editor_items");

	//未選択
	if(obj.options.selectedIndex==-1){
		return;
	}

	//移動先なし
	if(obj.options.selectedIndex==obj.options.length-1){
		return;
	}

	//実処理
	var itemOrder				=	Number(obj.options[obj.options.selectedIndex].value);
	blogEditorData.items		=	([])													.
									concat(	blogEditorData.items.slice(0,itemOrder)		)	.
									concat(	blogEditorData.items[itemOrder+1]			)	.
									concat(	blogEditorData.items[itemOrder]				)	.
									concat(	blogEditorData.items.slice(itemOrder+2)		)	;
	displayItems();
	obj.options.selectedIndex	=	itemOrder+1;
	displayEditArea();

}

/*--------------------------------------------------------------------------------
	アイテム削除
--------------------------------------------------------------------------------*/
function deleteItem(){

	var obj	=	document.getElementById("blog_editor_items");

	//未選択
	if(obj.options.selectedIndex==-1){
		return;
	}

	//実処理
	var itemOrder				=	Number(obj.options[obj.options.selectedIndex].value);
	blogEditorData.items		=	([])													.
									concat(	blogEditorData.items.slice(0,itemOrder)		)	.
									concat(	blogEditorData.items.slice(itemOrder+1)		)	;
	displayItems();

}

/*--------------------------------------------------------------------------------
	エディットエリアデータ記憶
--------------------------------------------------------------------------------*/
function memorizeEditArea(){

	var obj	=	document.getElementById("blog_editor_items");

	//未選択
	if(obj.options.selectedIndex==-1){
		return;
	}

	//実処理
	var itemOrder		=	Number(obj.options[obj.options.selectedIndex].value);
	blogEditorData.items[itemOrder].getEditAreaData();

}

/*--------------------------------------------------------------------------------
	エディットエリアデータ喚起
--------------------------------------------------------------------------------*/
function recollectEditArea(){

	var obj	=	document.getElementById("blog_editor_items");

	//未選択
	if(obj.options.selectedIndex==-1){
		return;
	}

	//実処理
	var itemOrder		=	Number(obj.options[obj.options.selectedIndex].value);
	blogEditorData.items[itemOrder].setEditAreaData();

}

/*--------------------------------------------------------------------------------
	エディットエリアデータ初期化
--------------------------------------------------------------------------------*/
function initializeEditArea(){

	var obj	=	document.getElementById("blog_editor_items");

	//未選択
	if(obj.options.selectedIndex==-1){
		return;
	}

	//実処理
	var itemOrder		=	Number(obj.options[obj.options.selectedIndex].value);
	document.getElementById("edit_area").innerHTML	=	blogEditorData.items[itemOrder].constructor.getEditAreaHTML();

}

/*--------------------------------------------------------------------------------
	ターゲットテキストエリアからデータをインポート
--------------------------------------------------------------------------------*/
function importData(){

	var obj	=	document.getElementById("blog_editor_target");

	//未選択
	if(obj.options.selectedIndex==-1){
		return;
	}

	//ターゲットID取得
	var targetId	=	obj.options[obj.options.selectedIndex].value;

	//ターゲット取得失敗
	if(!window.opener.document.getElementById(targetId)){
		window.alert("error:\ncan't get target textarea.");
		return;
	}

	//ターゲットのテキスト取得
	var targetValue	=	window.opener.document.getElementById(targetId).value;

	//ターゲットのテキストからデータを抽出
	var readData	=	getDataFromText(targetValue);

	if(readData.status=="nodata"){
		window.alert("error:\ncan't get data.");
		return;
	}

	//ハッシュチェック
	if(readData.status=="hasherrer"){
		if(!window.confirm("caution:\nnot match hash.\ncontinue?")){
			return;
		}
	}

	//データ取得
	var dataObject	=	readData.data;

	//テンプレート存在チェック
	for(var i=0;i<dataObject.length;i++){
		if(!blogEditorData.templatesData[dataObject[i].templateId]){
			window.alert("error:\nno exist template.");
			return;
		}
	}

	//上書確認
	if(blogEditorData.items.length!=0&&!window.confirm("caution:\noverwrite. ok?")){
		return;
	}

	blogEditorData.items	=	[];

	for(var i=0;i<dataObject.length;i++){
		var template		=	new blogEditorData.templatesData[dataObject[i].templateId];
		template.setData(dataObject[i].templateData);
		blogEditorData.items.push(template);
	}

	displayItems();

}

/*--------------------------------------------------------------------------------
	ターゲットテキストエリアにデータをエクスポート
--------------------------------------------------------------------------------*/
function exportData(){

	var obj	=	document.getElementById("blog_editor_target");

	//未選択
	if(obj.options.selectedIndex==-1){
		return;
	}

	//ターゲットID取得
	var targetId	=	obj.options[obj.options.selectedIndex].value;

	//ターゲット取得失敗
	if(!window.opener.document.getElementById(targetId)){
		window.alert("error:\ncan't get target textarea.");
		return;
	}

	//上書確認
	if(window.opener.document.getElementById(targetId).value.length!=0&&!window.confirm("caution:\noverwrite. ok?")){
		return;
	}

	var html	=	"";
	var data	=	[];
	var items	=	blogEditorData.items;

	for(var i=0;i<items.length;i++){
		var templateId		=	items[i].constructor.getId();
		var templateData	=	items[i].getData();
		var itemHTML		=	items[i].getHTML();
		html				+=	itemHTML+"\n";
		data				.push({"templateId":templateId,"templateData":templateData});
	}

	html				=	"<div class=\"Kanasansoft_BlogEditor\">"+html+"</div>\n";

	//ターゲットへテキスト反映
	window.opener.document.getElementById(targetId).value=html+getTextFromData(data);
}

/*--------------------------------------------------------------------------------
	HTMLコメントからデータを抽出
--------------------------------------------------------------------------------*/
function getDataFromText(str){

	var lines			=	str.replace(/\r\n/ig,"\n").replace(/\r/ig,"\n").split("\n");

	var readString		=	null;
	for(var i=lines.length-1;i>=0;i--){
		if(lines[i].match(/^<!--KanasansoftBlogEditorData_Start\((.*)\)KanasansoftBlogEditorData_End-->$/ig)){
			readString	=	RegExp.$1;
			break;
		}
	}

	//取得チェック
	if(readString==null){
		return {"status":"nodata"};
	}

	var readData		=	JSON.Decode(StringUtility.Decode.HTML(readString));
	dataString			=	readData.data;
	hashString			=	readData.hash;

	//ハッシュチェック
	if(CONSISTENCY_CHECK_FLAG&&MessageDigest.MD5(dataString).toLowerCase()!=hashString.toLowerCase()){
		return {"status":"hasherrer","data":JSON.Decode(dataString)};
	}

	return {"status":"ok","data":JSON.Decode(dataString)};

}

/*--------------------------------------------------------------------------------
	データをHTMLコメントで生成
--------------------------------------------------------------------------------*/
function getTextFromData(obj){
	var dataString	=	JSON.Encode(obj);
	var hashString	=	CONSISTENCY_CHECK_FLAG					?
						MessageDigest.MD5(dataString)			:
						StringUtility.getRepeatString("0",32)	;
	var writeData	=	{	"data"	:	dataString	,
							"hash"	:	hashString	};
	var writeString	=	StringUtility.Encode.HTML(JSON.Encode(writeData));
	return "\n<!--KanasansoftBlogEditorData_Start("+writeString+")KanasansoftBlogEditorData_End-->\n";
}
